implementation module
	StdNumber

import
	StdMisc, StdInt

// -------------------------------------------------------------------------------------------
:: Peano =
// -------------------------------------------------------------------------------------------
	  Zero
	| Succ		!Peano
















// -------------------------------------------------------------------------------------------
instance + Peano
// -------------------------------------------------------------------------------------------
where
	(+) Zero y
		= y
	(+) (Succ x) y
		= Succ (x + y)

// -------------------------------------------------------------------------------------------
instance - Peano
// -------------------------------------------------------------------------------------------
where
	(-) Zero y
		= Zero
	(-) (Succ x) Zero
		= Succ x
	(-) (Succ x) (Succ y)
		= x - y

// -------------------------------------------------------------------------------------------
instance * Peano
// -------------------------------------------------------------------------------------------
where
	(*) Zero y
		= Zero
	(*) (Succ x) y
		= (x * y) + y

// -------------------------------------------------------------------------------------------
instance < Peano
// -------------------------------------------------------------------------------------------
where
	(<) Zero Zero
		= False
	(<) Zero (Succ y)
		= True
	(<) (Succ x) Zero
		= False
	(<) (Succ x) (Succ y)
		= x < y

/*
// -------------------------------------------------------------------------------------------
:: Number =
// -------------------------------------------------------------------------------------------
	  Zero
	| Succ		Number
	| Pred		Number

// -------------------------------------------------------------------------------------------
toNumber :: !Int -> Number
// -------------------------------------------------------------------------------------------
toNumber n
	| n < 0				= negate (toPosNumber (~n))
	= toPosNumber n
	where
		toPosNumber 0
			= Zero
		toPosNumber n
			= Succ (toPosNumber (n-1))

// -------------------------------------------------------------------------------------------
fromNumber :: !Number -> Int
// -------------------------------------------------------------------------------------------
fromNumber Zero
	= 0
fromNumber (Succ x)
	= fromNumber x + 1
fromNumber (Pred x)
	= fromNumber x - 1

// -------------------------------------------------------------------------------------------
checkDefinedness :: !Number -> Bool
// -------------------------------------------------------------------------------------------
checkDefinedness Zero
	= True
checkDefinedness (Succ x)
	= checkDefinedness x
checkDefinedness (Pred x)
	= checkDefinedness x















// -------------------------------------------------------------------------------------------
wellFormedPos :: !Number -> Bool
// -------------------------------------------------------------------------------------------
wellFormedPos Zero
	= True
wellFormedPos (Succ x)
	= wellFormedPos x
wellFormedPos (Pred x)
	= False

// -------------------------------------------------------------------------------------------
wellFormedNeg :: !Number -> Bool
// -------------------------------------------------------------------------------------------
wellFormedNeg Zero
	= True
wellFormedNeg (Succ x)
	= False
wellFormedNeg (Pred x)
	= wellFormedNeg x

// -------------------------------------------------------------------------------------------
wellFormed :: !Number -> Bool
// -------------------------------------------------------------------------------------------
wellFormed Zero
	= True
wellFormed (Succ x)
	= wellFormedPos x
wellFormed (Pred x)
	= wellFormedNeg x







// -------------------------------------------------------------------------------------------
addSucc :: !Number -> Number
// -------------------------------------------------------------------------------------------
addSucc Zero
	= Succ Zero
addSucc (Succ x)
	= Succ (Succ x)
addSucc (Pred x)
	= x

// -------------------------------------------------------------------------------------------
addPred :: !Number -> Number
// -------------------------------------------------------------------------------------------
addPred Zero
	= Pred Zero
addPred (Succ x)
	= x
addPred (Pred x)
	= Pred (Pred x)














// -------------------------------------------------------------------------------------------
add :: !Number Number -> Number
// -------------------------------------------------------------------------------------------
add Zero y
	= y
add (Succ x) y
	= addSucc (add x y)
add (Pred x) y
	= addPred (add x y)

// -------------------------------------------------------------------------------------------
div :: !Number !Number -> Number
// -------------------------------------------------------------------------------------------
div x Zero
	= undef
div Zero y
	= Zero
div x y
	= case smaller x Zero of
		True	-> case smaller y Zero of
					True	-> posdiv (negate x) (negate y) (negate x)
					False	-> negate (posdiv (negate x) y (negate x)) 
		False	-> case smaller y Zero of
					True	-> negate (posdiv x (negate y) x)
					False	-> posdiv x y x

// -------------------------------------------------------------------------------------------
div2 :: Number Number -> Number
// -------------------------------------------------------------------------------------------
div2 x y
	= case y of
		Zero	-> undef
		_		-> case x of
					Zero	-> Zero
					_		-> case smaller x Zero of
								True	-> case smaller y Zero of
											True	-> posdiv (negate x) (negate y) (negate x)
											False	-> negate (posdiv (negate x) y (negate x)) 
								False	-> case smaller y Zero of
											True	-> negate (posdiv x (negate y) x)
											False	-> posdiv x y x

// -------------------------------------------------------------------------------------------
minus :: Number Number -> Number
// -------------------------------------------------------------------------------------------
minus x y
	= add x (negate y)

// -------------------------------------------------------------------------------------------
negate :: !Number -> Number
// -------------------------------------------------------------------------------------------
negate Zero
	= Zero
negate (Succ x)
	= Pred (negate x)
negate (Pred x)
	= Succ (negate x)

// -------------------------------------------------------------------------------------------
posdiv :: Number Number !Number -> Number
// -------------------------------------------------------------------------------------------
posdiv x y Zero
	= Zero
posdiv x y (Succ d)
	= case smaller x (times y (Succ d)) of
		True	-> posdiv x y d
		False	-> Succ d

// -------------------------------------------------------------------------------------------
times :: !Number Number -> Number
// -------------------------------------------------------------------------------------------
times Zero y
	= Zero
times (Succ x) y
	= add (times x y) y
times (Pred x) y
	= minus (times x y) y












// -------------------------------------------------------------------------------------------
even :: !Number -> Bool
// -------------------------------------------------------------------------------------------
even Zero
	= True
even (Succ x)
	= odd x
even (Pred x)
	= odd x

// -------------------------------------------------------------------------------------------
odd :: !Number -> Bool
// -------------------------------------------------------------------------------------------
odd Zero
	= False
odd (Succ x)
	= even x
odd (Pred x)
	= even x

// -------------------------------------------------------------------------------------------
smaller :: !Number !Number -> Bool
// -------------------------------------------------------------------------------------------
smaller Zero Zero
	= False
smaller Zero (Succ x)
	= True
smaller Zero (Pred x)
	= False
smaller (Succ x) Zero
	= False
smaller (Succ x) (Succ y)
	= smaller x y
smaller (Succ x) (Pred y)
	= False
smaller (Pred x) Zero
	= True
smaller (Pred x) (Succ y)
	= True
smaller (Pred x) (Pred y)
	= smaller x y




// Marco
/*
isNeg :: !Number -> Bool
isNeg Zero = False
isNeg (Succ x) = False
isNeg (Pred x) = True
*/

normalize :: !Number -> Number
normalize Zero
	= Zero
normalize (Succ x)
	= case (normalize x) of
		(Pred y)	= y
		(Succ y)	= Succ (Succ y)
		Zero		= Succ Zero
normalize (Pred x)
	= case (normalize x) of
		(Succ y)	= y
		(Pred y)	= Pred (Pred y)
		Zero		= Pred Zero







Start
	= fromNumber (div (toNumber (~26)) (toNumber (~3)))
*/